﻿#pragma once

#if       !defined(INCLUDED_STD_VECTOR)
#include  <vector>
#endif // !defined(INCLUDED_STD_VECTOR)

#if       !defined(INCLUDED_STD_DEQUE)
#include  <deque>
#endif // !defined(INCLUDED_STD_DEQUE)

enum CommandArgType
{
  None = 0, // 引数なし
  Single,   // 一つの引数
  Multiple, // 一つ以上の任意個の引数
};

enum CommandType
{                 
  UndefinedCommand = 0,
  DecompressCommand,
  CompressCommand,
  CompressAsCommand,
  InputPathCommand,
  OutputPathCommand,
  LevelCommand,
  VerboseCommand,
  //CommandFile, // Unicode ビルドなので、ASCII を読み込むのが面倒で、とりあえずやめている。
};

class Command
{
public:

  Command(CommandType commandType, const std::vector<szstring> &commandArgs);
  ~Command();

  CommandType GetType() const { return type; }
  const std::vector<szstring> &GetArgs() const { return args; }
  std::vector<szstring>       &GetArgs()       { return args; }

private:

  CommandType type;
  std::vector<szstring> args;
};

std::deque<Command> ParseCommands(const szstring &cmdline);
